' Started....15/05/16
' Microcontroller used:  Microchip Technology PIC16F88
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------

' The program uses one of the analog-to-digital
' converters,(AN4), to measure the voltage 
' on the output of the voltage amplifier IC(an analog signal).
' It then converts the analog voltage into an 10-bit
' digital value (0 to 1023), displays the answer on
' LCD. The device first measure the ADC value on the smallest resistor
'and if it is <10 then the next highest resistance is selected. This is done by
'switching mosfets on and off.
'
'
' 
   #CONFIG
 __CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
 #ENDCONFIG
 
 
 
    define LCD_DREG PORTB'PORTB is LCD data PORT
    define LCD_DBIT 0 'PORTB.0 is the data lowest significanr bit  
    define LCD_RSREG PORTB   ' PORTB - RS port   
    define LCD_RSBIT 4       ' RS bit connects to PORTB.4
    define LCD_EREG PORTB ' PORTB E PORT
    define LCD_EBIT 5    ' E to RB5
    Define LCD_BITS 4 '4 data lines used
    define LCD_LINES 2  'LCD display has 2 lines
    Define LCD_COMMANDUS 1500 'Set data delay time to 1.5ms
    define LCD_DATAUS 44 'Set data delay to 44 micro second
    
    Define  ADC_BITS     10    ' Set number of bits in result
	Define  ADC_CLOCK    3     ' Set clock source (3=rc)
	Define  ADC_SAMPLEUS 50    ' Set sampling time in uS
	 
       
'------------Variables-------------
     
     x  var word 
     y var word 
     z var word         '     
     
'----------Initialization----------

    ANSEL = %00010000  ' Leaves AN4 in analog mode, but                 
                       ' changes other analog bits to digital.
    TRISB = %10000000 ' RB7 input rest outputs                   
    TRISA = %00111100 'RA2, RA3, RA4, RA5 inputs rest outputs                  
   ADCON1 =  %10110000  ' Bit 7 Right justifies 10-bit value of x
                        ' in 16-bit WORD. Adds "0" in the
                        ' 6 Most Significant bits of the Word,
                        ' shifting the 10-bit value of x to
                        ' the right. This changes the LCD
                        ' values to 0 - 1023. Bit 4 and bit 5
                        'make RA2 Vref- and RA3 vre+
'    

'
                                
    OSCCON = $60	            ' Sets the internal oscillator in the
                                ' 16F88 to 4 MHz   	    
    
'-------------Main Code------------

pause 300  ' Pause to allow LCD to setup

X = 0
Y = 0
z = 0

range10A: '1 to 10A 
PORTA.7 = 0 '10A range on rest off  
PORTA.6 = 0 '10A range on rest off 
PORTA.1 = 0 '10A range on rest off  
pause 150  'allow amp to settle before reading ADC
range10R:
adcin 4, x  'Read the value of the analogue input voltage and stores it as a 10bit word in X
if X > 1020   then goto over
if X < 90 then goto range1A
Y = X/100
Z = X//1000
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line
LCDout DEC Y, ".", dec2 z," A "
pause 400
goto range10R

range1A:
PORTA.7 = 1 '1A range on rest off 
PORTA.6 = 0 '1A range on rest off
PORTA.1 = 0 '1A range on rest off 
pause 150 'allow amp to settle before reading ADC
range1AR:
adcin 4, X
if X > 1000 then goto range10A
if X < 90 then goto range100ma
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line
LCDout DEC x, " ma"
pause 400
goto range1AR

range100ma:
PORTA.7 = 0 '100ma range on rest off 
PORTA.6 = 1 '100ma range on rest off
PORTA.1 = 0 '100ma range on rest off 
pause 150 'allow amp to settle before reading ADC
range100maR:
adcin 4, X  
if X > 1000 then goto range1A
if X < 90 then goto range10ma
y = x/10
z = X//100
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line 
LCDout DEC Y, ".", dec1 z," ma "
pause 400
goto range100maR 

range10ma:
PORTA.7 = 1 '10ma range on rest off 
PORTA.6 = 1 '10ma range on rest off
PORTA.1 = 0 '10ma range on rest off  
pause 150 'allow amp to settle before reading ADC
range10maR:
adcin 4, X
if X > 1000 then goto range100ma
if X < 90 then goto range1000
Y = X/100
z = x//1000
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line  
LCDout DEC Y, ".", dec2 z," ma "
pause 400
goto range10maR

over:
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line 
lcdout "OVER RANGE"
if PORTB.7 = 1 then 'if link is not in place ie no cutout
pause 100
goto range10A
endif
if PORTB.7 = 0 then 'if link LK1 in place switch all fets off
PORTA.7 = 1 'pin 4 high (not connected) rest off  
PORTA.6 = 1 'pin 4 high (not connected) rest off
PORTA.1 = 1 'pin 4 high (not connected) rest off
endif
stop

range1000:
PORTA.7 = 0 '1ma range on rest off 
PORTA.6 = 0 '1ma range on rest off
PORTA.1 = 1 '1ma range on rest off 
pause 150 'allow amp to settle before reading ADC
range1000R:
adcin 4, X
if X > 1000 then goto range10ma
if X < 90 then goto range100
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line
LCDout DEC X, " microamps"
pause 400
goto range1000R

range100:
PORTA.7 = 1 '0.1ma range on rest off  
PORTA.6 = 0 '0.1ma range on rest off 
PORTA.1 = 1 '0.1ma range on rest off 
pause 150'allow amp to settle before reading ADC
range100R:
adcin 4, X 'read ADC with new range selected
if X > 1000 then goto range1000
Y = X/10
Z = x//100
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line 
LCDout DEC y, ".",dec1 z, " microamp "
pause 400
goto range100R








 end

	


